package com.vmware.samples.actions {

import com.vmware.core.model.IResourceReference;
import com.vmware.flexutil.proxies.BaseProxy;
import com.vmware.flexutil.ServiceUtil;

/**
 * Proxy class for the VmActionService java service
 */
public class ActionCommandProxy extends BaseProxy
{
   // This service name must match the flex:remoting-destination in bundle-context.xml
   private static const SERVICE_NAME:String = "VmActionService";

   /**
    * Create an ActionCommandProxy with a secure channel.
    */
   public function ActionCommandProxy() {
      // channelUri uses the Web-ContextPath defined in MANIFEST.MF
      const channelUri:String = ServiceUtil.getDefaultChannelUri(Vmactionui.contextPath);
      super(SERVICE_NAME, channelUri);
   }

   /**
    * Call the "backendAction" method of VmActionService.
    *
    * @param vmObject      The selected VM
    * @param callBack      Optional callback method
    * @param callContext   Optional object that is passed back in the callback method
    */
   public function backendAction(vmObject:IResourceReference, callback:Function = null,
                               context:Object = null):void {
      callService("backendAction", [vmObject], callback, context);
   }
}
}